SET @sName := 'bx_photos_autoalbum';
SET @sIcon := 'bx_photos_autoalbum@modules/gspsoft/photos_autoalbum/|std-icon.svg';
SET @sClass := 'BxPhotosAutoAlbumAlerts';
SET @sFile := 'modules/gspsoft/photos_autoalbum/classes/BxPhotosAutoAlbumAlerts.php';

-- Studio page & widget (so the app appears in Studio dashboard)
DELETE FROM `tp`, `tw`, `twb`, `tpw`
USING `sys_std_pages` AS `tp`
LEFT JOIN `sys_std_widgets` AS `tw` ON `tp`.`id` = `tw`.`page_id`
LEFT JOIN `sys_std_widgets_bookmarks` AS `twb` ON `tw`.`id` = `twb`.`widget_id`
LEFT JOIN `sys_std_pages_widgets` AS `tpw` ON `tw`.`id` = `tpw`.`widget_id`
WHERE `tp`.`name` = @sName;

INSERT INTO `sys_std_pages` (`index`, `name`, `header`, `caption`, `icon`) VALUES
(3, @sName, '_bx_photos_autoalbum', '_bx_photos_autoalbum', @sIcon);
SET @iPageId := LAST_INSERT_ID();

SET @iParentPageId := (SELECT `id` FROM `sys_std_pages` WHERE `name` = 'home');
SET @iParentPageOrder := (SELECT MAX(`order`) FROM `sys_std_pages_widgets` WHERE `page_id` = @iParentPageId);
INSERT INTO `sys_std_widgets` (`page_id`, `module`, `type`, `url`, `click`, `icon`, `caption`, `cnt_notices`, `cnt_actions`) VALUES
(@iPageId, @sName, 'extensions', CONCAT('{url_studio}module.php?name=', @sName), '', @sIcon, '_bx_photos_autoalbum', '', 'a:4:{s:6:"module";s:6:"system";s:6:"method";s:11:"get_actions";s:6:"params";a:0:{}s:5:"class";s:18:"TemplStudioModules";}');
INSERT INTO `sys_std_pages_widgets` (`page_id`, `widget_id`, `order`) VALUES
(@iParentPageId, LAST_INSERT_ID(), IFNULL(@iParentPageOrder, 0) + 1);

SET @iExistingHandler := (SELECT `id` FROM `sys_alerts_handlers` WHERE `name` = @sName LIMIT 1);
DELETE FROM `sys_alerts` WHERE `handler_id` = @iExistingHandler;
DELETE FROM `sys_alerts_handlers` WHERE `id` = @iExistingHandler;

INSERT INTO `sys_alerts_handlers` (`name`, `class`, `file`, `service_call`, `active`)
VALUES (@sName, @sClass, @sFile, '', 1);
SET @handlerId := LAST_INSERT_ID();

INSERT INTO `sys_alerts` (`unit`, `action`, `handler_id`) VALUES
('system', 'store_file', @handlerId),
('system', 'page_output_done', @handlerId);
